/* ***********************************************************
 * Smart Cards: Toward a Modern Run-time Platform
 * ETH Zurich, WS 2005/2006
 *************************************************************/

package perfdemo;

import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.ISO7816;
import javacard.framework.ISOException;
import javacard.framework.Util;
import perfdemo.tests.CompoundTest;
import perfdemo.tests.FirstLocalsTest;
import perfdemo.tests.IfElseVsLookupSwitchTest;
import perfdemo.tests.LocalVarTest;
import perfdemo.tests.MemoryTest;
import perfdemo.tests.SwitchVsIfElseTest;
import perfdemo.tests.TableVsLookupSwitchTest;
import perfdemo.tests.Test;

public class PerfApplet extends Applet {

	private final Test[] tests;

	private PerfApplet() {
		tests = new Test[7];
		tests[0] = new CompoundTest();
		tests[1] = new LocalVarTest();
		tests[2] = new FirstLocalsTest();
		tests[3] = new SwitchVsIfElseTest();
		tests[4] = new TableVsLookupSwitchTest();
		tests[5] = new IfElseVsLookupSwitchTest();
		tests[6] = new MemoryTest();
	}

	public static void install(byte[] bArray, short bOffset, byte bLength) {
		new PerfApplet().register(bArray, (short) (bOffset + 1),
				bArray[bOffset]);
	}

	public void process(APDU apdu) {
		if (selectingApplet()) {
			return;
		}

		byte[] buf = apdu.getBuffer();
		Test test;
		short n;
		switch (buf[ISO7816.OFFSET_INS]) {
		case (byte) 0x00: // no of tests
			apdu.setOutgoingAndSend((short) 0, Util.setShort(buf, (short) 0,
					(short) tests.length));
			break;
		case (byte) 0x02: // name of test in P1/P2
			apdu.setOutgoingAndSend((short) 0, tests[Util.getShort(buf,
					ISO7816.OFFSET_P1)].getName(buf, (short) 0));
			break;
		case (byte) 0x04: // run overhead test
			n = (test = tests[Util.getShort(buf, ISO7816.OFFSET_P1)])
					.getIterations();
			while (n-- > 0) {
				test.overhead(buf);
			}
			break;
		case (byte) 0x06: // run unoptimized test in P1/P2
			n = (test = tests[Util.getShort(buf, ISO7816.OFFSET_P1)])
					.getIterations();
			while (n-- > 0) {
				test.run(buf);
			}
			break;
		case (byte) 0x08: // run optimized test in P1/P2
			n = (test = tests[Util.getShort(buf, ISO7816.OFFSET_P1)])
					.getIterations();
			while (n-- > 0) {
				test.run_optimized(buf);
			}
			break;
		default:
			ISOException.throwIt(ISO7816.SW_INS_NOT_SUPPORTED);
		}
	}
}