/* ***********************************************************
 * Smart Cards: Toward a Modern Run-time Platform
 * ETH Zurich, WS 2005/2006
 *************************************************************/

package perfdemo.tests;

import javacard.framework.Util;

public class CompoundTest implements Test {

	private final byte[] NAME = { (byte) 'C', (byte) 'o', (byte) 'm',
			(byte) 'p', (byte) 'o', (byte) 'u', (byte) 'n', (byte) 'd',
			(byte) ' ', (byte) 'S', (byte) 't', (byte) 'a', (byte) 't',
			(byte) 'e', (byte) 'm', (byte) 'e', (byte) 'n', (byte) 't',
			(byte) 's' };

	public short getName(byte[] buf, short off) {
		short n;
		Util.arrayCopyNonAtomic(NAME, (short) 0, buf, off,
				(n = (short) NAME.length));
		return n;
	}

	public short getIterations() {
		return 1000;
	}

	public void overhead(byte[] buf) {
		short a = 4;
		short b = 5;
		short c = 6;
		short x;
	}

	public void run(byte[] buf) {
		short a = 4;
		short b = 5;
		short c = 6;
		short x;
		x = (short) (a + b);
		x = (short) (x - c);
	}

	public void run_optimized(byte[] buf) {
		short a = 4;
		short b = 5;
		short c = 6;
		short x;
		x = (short) (a + b - c);
	}
}
