/* ***********************************************************
 * Smart Cards: Toward a Modern Run-time Platform
 * ETH Zurich, WS 2005/2006
 *************************************************************/

package perfdemo.tests;

import javacard.framework.Util;

public class FirstLocalsTest implements Test {

	private final byte[] NAME = { (byte) 'F', (byte) 'i', (byte) 'r',
			(byte) 's', (byte) 't', (byte) ' ', (byte) '4', (byte) ' ',
			(byte) 'L', (byte) 'o', (byte) 'c', (byte) 'a', (byte) 'l',
			(byte) 's' };

	public short getName(byte[] buf, short off) {
		short n;
		Util.arrayCopyNonAtomic(NAME, (short) 0, buf, off,
				(n = (short) NAME.length));
		return n;
	}

	public short getIterations() {
		return 1000;
	}

	public void overhead(byte[] buf) {
		short s1;
		short s2 = 0;
		short s3;
		short s4;
		short s5 = 0;
	}

	public void run(byte[] buf) {
		short s1;
		short s2 = 0;
		short s3;
		short s4;
		short s5 = 0;
		for (s4 = 0; s4 < 100; s4++) {
			s5--;
		}
	}

	public void run_optimized(byte[] buf) {
		short s1;
		short s2 = 0;
		short s3;
		short s4;
		short s5 = 0;
		for (s1 = 0; s1 < 100; s1++) {
			s2--;
		}
	}
}
