/* ***********************************************************
 * Smart Cards: Toward a Modern Run-time Platform
 * ETH Zurich, WS 2005/2006
 *************************************************************/

package perfdemo.tests;

import javacard.framework.Util;

public class IfElseVsLookupSwitchTest implements Test {

	private final byte[] NAME = { (byte) 'I', (byte) 'f', (byte) '-',
			(byte) 'E', (byte) 'l', (byte) 's', (byte) 'e', (byte) ' ',
			(byte) 'v', (byte) 's', (byte) '.', (byte) ' ', (byte) 'L',
			(byte) 'o', (byte) 'o', (byte) 'k', (byte) 'u', (byte) 'p',
			(byte) ' ', (byte) 's', (byte) 'w', (byte) 'i', (byte) 't',
			(byte) 'c', (byte) 'h' };

	public short getName(byte[] buf, short off) {
		short n;
		Util.arrayCopyNonAtomic(NAME, (short) 0, buf, off,
				(n = (short) NAME.length));
		return n;
	}

	public short getIterations() {
		return 1000;
	}

	public void overhead(byte[] buf) {
		short a = 65;
		nop();
	}

	public void run(byte[] buf) {
		short a = 65;
		switch (a) {
		case 65:
			nop();
			break;
		case 25:
			nop();
			break;
		case 35:
			nop();
			break;
		case 45:
			nop();
			break;
		case 55:
			nop();
			break;
		case 15:
			nop();
			break;
		default:
			nop();
			break;
		}
	}

	public void run_optimized(byte[] buf) {
		short a = 65;
		if (a == 65) {
			nop();
		} else if (a == 25) {
			nop();
		} else if (a == 35) {
			nop();
		} else if (a == 45) {
			nop();
		} else if (a == 55) {
			nop();
		} else if (a == 15) {
			nop();
		} else {
			nop();
		}
	}

	private void nop() {

	}
}
