/* ***********************************************************
 * Smart Cards: Toward a Modern Run-time Platform
 * ETH Zurich, WS 2005/2006
 *************************************************************/

package perfdemo.tests;

import javacard.framework.ISO7816;
import javacard.framework.Util;

public class LocalVarTest implements Test {

	private final byte[] NAME = { (byte) 'L', (byte) 'o', (byte) 'c',
			(byte) 'a', (byte) 'l', (byte) ' ', (byte) 'v', (byte) 'a',
			(byte) 'r', (byte) 'i', (byte) 'a', (byte) 'b', (byte) 'l',
			(byte) 'e', (byte) 's', (byte) ' ', (byte) 'a', (byte) 's',
			(byte) ' ', (byte) 'v', (byte) 'a', (byte) 'l', (byte) 'u',
			(byte) 'e', (byte) ' ', (byte) 'c', (byte) 'a', (byte) 'c',
			(byte) 'h', (byte) 'e' };

	public short getName(byte[] buf, short off) {
		short n;
		Util.arrayCopyNonAtomic(NAME, (short) 0, buf, off,
				(n = (short) NAME.length));
		return n;
	}

	public short getIterations() {
		return 1000;
	}

	public void overhead(byte[] buf) {
		buf[ISO7816.OFFSET_INS] = (byte) 3;
		nop();
	}

	public void run(byte[] buf) {
		buf[ISO7816.OFFSET_INS] = (byte) 3;
		if (buf[ISO7816.OFFSET_INS] == 0) {
			nop();
		} else if (buf[ISO7816.OFFSET_INS] == 1) {
			nop();
		} else if (buf[ISO7816.OFFSET_INS] == 2) {
			nop();
		} else if (buf[ISO7816.OFFSET_INS] == 3) {
			nop();
		}
	}

	public void run_optimized(byte[] buf) {
		buf[ISO7816.OFFSET_INS] = (byte) 3;
		byte ins;
		if ((ins = buf[ISO7816.OFFSET_INS]) == 0) {
			nop();
		} else if (ins == 1) {
			nop();
		} else if (ins == 2) {
			nop();
		} else if (ins == 3) {
			nop();
		}
	}

	public void nop() {

	}
}
