/* ***********************************************************
 * Smart Cards: Toward a Modern Run-time Platform
 * ETH Zurich, WS 2005/2006
 *************************************************************/

package perfdemo.tests;

import javacard.framework.Util;

public class MemoryTest implements Test {

	private final byte[] NAME = { (byte) 'E', (byte) 'E', (byte) 'P',
			(byte) 'R', (byte) 'O', (byte) 'M', (byte) ' ', (byte) 'v',
			(byte) 's', (byte) '.', (byte) ' ', (byte) 'R', (byte) 'A',
			(byte) 'M' };

	public short getName(byte[] buf, short off) {
		short n;
		Util.arrayCopyNonAtomic(NAME, (short) 0, buf, off,
				(n = (short) NAME.length));
		return n;
	}

	private short field;

	public short getIterations() {
		return 10;
	}

	public void overhead(byte[] buf) {
		short local;
	}

	public void run(byte[] buf) {
		short local;
		field = 100;
		while (field-- > 0)
			;
	}

	public void run_optimized(byte[] buf) {
		short local;
		local = 100;
		while (local-- > 0)
			;
	}
}
