/* ***********************************************************
 * Smart Cards: Toward a Modern Run-time Platform
 * ETH Zurich, WS 2005/2006
 *************************************************************/

package perfdemo.tests;

import javacard.framework.Util;

public class SwitchVsIfElseTest implements Test {

	private final byte[] NAME = { (byte) 'S', (byte) 'w', (byte) 'i',
			(byte) 't', (byte) 'c', (byte) 'h', (byte) ' ', (byte) 'v',
			(byte) 's', (byte) '.', (byte) ' ', (byte) 'I', (byte) 'f',
			(byte) '-', (byte) 'E', (byte) 'l', (byte) 's', (byte) 'e' };

	public short getName(byte[] buf, short off) {
		short n;
		Util.arrayCopyNonAtomic(NAME, (short) 0, buf, off,
				(n = (short) NAME.length));
		return n;
	}

	public short getIterations() {
		return 1000;
	}

	public void overhead(byte[] buf) {
		short a = 65;
		nop();
	}

	public void run(byte[] buf) {
		short a = 65;
		if (a == 60) {
			nop();
		} else if (a == 61) {
			nop();
		} else if (a == 62) {
			nop();
		} else if (a == 63) {
			nop();
		} else if (a == 64) {
			nop();
		} else if (a == 65) {
			nop();
		} else {
			nop();
		}
	}

	public void run_optimized(byte[] buf) {
		short a = 65;
		switch (a) {
		case 60:
			nop();
			break;
		case 61:
			nop();
			break;
		case 62:
			nop();
			break;
		case 63:
			nop();
			break;
		case 64:
			nop();
			break;
		case 65:
			nop();
			break;
		default:
			nop();
			break;
		}
	}

	private void nop() {

	}
}
