/* ***********************************************************
 * Smart Cards: Toward a Modern Run-time Platform
 * ETH Zurich, WS 2005/2006
 *************************************************************/

package perfdemo.tests;

import javacard.framework.Util;

public class TableVsLookupSwitchTest implements Test {

	private final byte[] NAME = { (byte) 'T', (byte) 'a', (byte) 'b',
			(byte) 'l', (byte) 'e', (byte) ' ', (byte) 'v', (byte) 's',
			(byte) '.', (byte) ' ', (byte) 'L', (byte) 'o', (byte) 'o',
			(byte) 'k', (byte) 'u', (byte) 'p', (byte) ' ', (byte) 's',
			(byte) 'w', (byte) 'i', (byte) 't', (byte) 'c', (byte) 'h' };

	public short getName(byte[] buf, short off) {
		short n;
		Util.arrayCopyNonAtomic(NAME, (short) 0, buf, off,
				(n = (short) NAME.length));
		return n;
	}

	public short getIterations() {
		return 1000;
	}

	public void overhead(byte[] buf) {
		short a = 65;
		nop();
	}

	public void run(byte[] buf) {
		short a = 65;
		switch (a) {
		case 15:
			nop();
			break;
		case 25:
			nop();
			break;
		case 35:
			nop();
			break;
		case 45:
			nop();
			break;
		case 55:
			nop();
			break;
		case 65:
			nop();
			break;
		default:
			nop();
			break;
		}
	}

	public void run_optimized(byte[] buf) {
		short a = 65;
		switch (a) {
		case 60:
			nop();
			break;
		case 61:
			nop();
			break;
		case 62:
			nop();
			break;
		case 63:
			nop();
			break;
		case 64:
			nop();
			break;
		case 65:
			nop();
			break;
		default:
			nop();
			break;
		}
	}

	private void nop() {

	}
}
