/* ***********************************************************
 * Smart Cards: Toward a Modern Run-time Platform
 * ETH Zurich, WS 2005/2006
 *************************************************************/

package perftestclient;

import java.io.UnsupportedEncodingException;

import com.ibm.jc.JCApplet;
import com.ibm.jc.JCUtil;
import com.ibm.jc.JCard;

public class PerfTestApplet extends JCApplet {
	private static final byte[] AID = "perfdemo.app".getBytes();

	private final JCard card;

	public PerfTestApplet(JCard card, byte[] aid) {
		super(card, aid);
		this.card = card;
	}

	public PerfTestApplet(JCard card) {
		this(card, AID);
	}

	public PerfTestApplet(JCApplet app) {
		this(app.getCard(), app.getAID());
	}

	public int getNoTests() {
		byte[] rapdu = JCUtil.chop9000(card.send(0, 0x00, 0x00, 0x00, 0x00, -1,
				null, 0, 2));
		return JCUtil.getMSBF(rapdu, 0, rapdu.length);
	}

	public String getTestName(int no) {
		byte[] rapdu = JCUtil.chop9000(card.send(0, 0x00, 0x02, no >> 8, no,
				-1, null, 0, 2));
		try {
			return new String(rapdu, "US-ASCII");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return new String(rapdu);
		}
	}

	public void runOverHead(int no) {
		JCUtil
				.check9000(card.send(0, 0x00, 0x04, no >> 8, no, -1, null, 0,
						-1));
	}

	public void runTest(int no) {
		JCUtil
				.check9000(card.send(0, 0x00, 0x06, no >> 8, no, -1, null, 0,
						-1));
	}

	public void runOptimizedTest(int no) {
		JCUtil
				.check9000(card.send(0, 0x00, 0x08, no >> 8, no, -1, null, 0,
						-1));
	}
}
