/* ***********************************************************
 * Smart Cards: Toward a Modern Run-time Platform
 * ETH Zurich, WS 2005/2006
 *************************************************************/

package purse;

import java.rmi.RemoteException;

import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.UserException;
import javacard.framework.service.CardRemoteObject;
import javacard.framework.service.Dispatcher;
import javacard.framework.service.RMIService;

public class PurseApplet extends Applet implements PurseInterface {

	public static void install(byte[] bArray, short bOffset, byte bLength) {
		new PurseApplet().register(bArray, (short) (bOffset + 1),
				bArray[bOffset]);
	}

	private static final short MAX_BALANCE = 1000;

	private final Dispatcher dispatcher;

	private short balance;

	private PurseApplet() {
		CardRemoteObject.export(this);
		dispatcher = new Dispatcher((short) 1);
		dispatcher.addService(new RMIService(this), Dispatcher.PROCESS_COMMAND);
	}

	public void process(APDU apdu) {
		dispatcher.process(apdu);
	}

	public void credit(short amount) throws UserException, RemoteException {
		if (amount < 0) {
			UserException.throwIt(SW_INVALID_AMOUNT);
		}
		if (balance + amount > MAX_BALANCE) {
			UserException.throwIt(SW_MAX_BALANCE_EXC);
		}
		balance += amount;
	}

	public void debit(short amount) throws UserException, RemoteException {
		if (amount < 0) {
			UserException.throwIt(SW_INVALID_AMOUNT);
		}
		if (balance - amount < 0) {
			UserException.throwIt(SW_NEG_BALANCE);
		}
		balance -= amount;
	}

	public short getBalance() throws RemoteException {
		return balance;
	}

}