package quaddemo;

import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.Util;
import javacard.framework.service.Dispatcher;
import javacard.framework.JCSystem;
import quadlinkgui.QuadService;
import quadlinkgui.QuadService.QuadApplet;

public class QuadDemo extends Applet implements QuadApplet{

	private static final byte[] IDENT = {'r', 's', 't'};

	public static void install(byte[] bArray, short bOffset, byte bLength) {
		new QuadDemo().register(bArray, (short) (bOffset + 1), bArray[bOffset]);
	}
	
	byte [] feld, sC;
	byte tie;
	
	private Dispatcher dispatcher;
	
	private QuadDemo() {
		(dispatcher=new Dispatcher((short) 1)).addService(new QuadService(this), Dispatcher.PROCESS_COMMAND);
		feld = JCSystem.makeTransientByteArray((short) 78,JCSystem.CLEAR_ON_DESELECT);
		sC = JCSystem.makeTransientByteArray((short) 7,JCSystem.CLEAR_ON_DESELECT);
	}
	public void process(APDU apdu) {
			dispatcher.process(apdu);
		}

	public byte play(byte op) {
		byte pos;
		byte t2,t1,t0;
		byte mZ=NO_MOVE;
		if (op==0x0F) {
			if (sC[3]<6) {mZ=3;}
		}
		else {
			tie++;
			if (sC[op]<6){
				feld[(pos=(byte) ((sC[op]++)*13+op+3))]=1;
				if (zW(pos, (byte) 1, op)==100){return  MASK_YOUWIN|NO_MOVE;}
			}
			if (tie==42){return (byte) (NO_MOVE|MASK_TIE);}
			t0=-101;
			for (byte j=0;j<7;j++){
				if (sC[j]<6){
					feld[(pos=(byte) ((sC[j]++)*13+j+3))]=2;
					if (zW(pos,(byte) 2, j)==100){
						tie++;
						return (byte) (MASK_IWIN|j);
					}
					t1=101;
					for (byte y=0;y<7;y++){
						if (sC[y]<6){
							feld[(pos=(byte) (sC[y]*13+y+3))]=1;
							if ((t2=(byte) (-zW(pos, (byte) 1, y)))<t1){
								if ((t1=t2)==-100){
									feld[pos]=0;
									break;
								}
							}
							feld[pos]=0;
						}
					}
					if (t1>t0){
						t0=t1;
						mZ=j;
					}
					feld[(byte) ((--sC[j])*13+j+3)]=0;
				}
			}
		}
		if (sC[mZ]<6){
			feld[(byte) ((sC[mZ]++)*13+mZ+3)]=2;
		}
		if (++tie==42){return (byte) (mZ|MASK_TIE);}
		return mZ;
	}

	public byte zW(byte pos, byte pa, byte zug){
		byte c=0;
		byte cM=0;
			for(byte k=(byte) (pos-3);k<(pos+4);k++){
				if (k>=0&&k<78&&feld[k]==pa){if(++c>cM){cM=c;};}
				else {c=0;}
			}
			c=0;
			for(byte k=(byte) (pos-36);k<(pos+37);k+=12){
				if (k>=0&&k<78&&feld[k]==pa){if(++c>cM){cM=c;};}
				else {c=0;}
			}
			c=0;
			for(byte k=(byte) (pos-42);k<(pos+43);k+=14){
				if (k>=0&&k<78&&feld[k]==pa){if(++c>cM){cM=c;};}
				else {c=0;}
			}
			c=0;
			for(byte k=(byte) (pos-39);k<(pos+40);k+=13){
				if (k>=0&&k<78&&feld[k]==pa){if(++c>cM){cM=c;};}
				else {c=0;}
			}
			if (cM>=4){return 100;}
			else {switch (zug) {
			case 1: return (byte) ((cM-1)*10+1);
			case 2: return (byte) ((cM-1)*10+2);
			case 3: return (byte) ((cM-1)*10+3);
			case 4: return (byte) ((cM-1)*10+2);
			case 5: return (byte) ((cM-1)*10+1);
			default: return (byte) ((cM-1)*10);
			}}
	}
	
	public void reset() {
		tie=0;
		for (byte i=0;i<7;i++){
			sC[i]=0;
			for (byte j=0;j<6;j++){
				feld[j*13+i+3]=0;
			}
		}
	}
	public short identify(byte[] bArray, short bOffset) {
		short ln;
		Util.arrayCopyNonAtomic(IDENT, (short) 0, bArray, bOffset, (ln=(short) IDENT.length));
		return ln;
	}
}
