/**
 *     QUADLINK EXERCISE 
 *     Daniel Kopf
 *     2007-01-18
 */
package snippet2;
//package quaddemo;
//import javacard.framework.ISO7816;
//import javacard.framework.ISOException;
import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.Util;
import javacard.framework.service.Dispatcher;
import quadlinkgui.QuadService;
import quadlinkgui.QuadService.QuadApplet;

public class Snippet2 extends Applet implements QuadApplet {

	private static final byte[] IDENT = { (byte) 'D', (byte) 'a', (byte) 'n', (byte) 'i', (byte) 'e', (byte) 'l' };
	
	public byte BEST_MOVE 			= (byte)3;	// look ahead will result in BEST_MOVE with value of proposed X column
	public byte LOOK_AHEAD_DEPTH 	= (byte)3;	// look ahead, how many look aheads moves of ...
	public boolean	GAME_TIED 		= false;	// =true if game I will win, i.e. game tied i.e. opponent bound to loose
	public boolean	YOU_WIN 		= false;	// =true if oppenent has won
	public boolean	I_WIN 			= false; 	// =true if I / this applet has won
	public boolean	NO_MORE_MOVES	= false;	// =true if field is full i.e. no more move can be taken
	public byte 	count_hor = 0x01;  			// count how many are connected, horizontal 
	public byte 	count_ver = 0x01;  			// count how many are connected, vertical
	public byte 	count_cw  = 0x01; 			// count how many are connected, 45 deg clockwise direction
	public byte 	count_ccw = 0x01;			// count how many are connected, 45 deg counter clockwise direction

	public static byte		YELLOW =	(byte)1;
	public static byte		RED =		(byte)2;
	
	public static byte SETBD[] = new byte[42];				/* 	* this array contains value, which: =0 if "no color",
														* 									=1 if YELLOW/opp/x
														*	XY=..					y=..	=2 if RED/this applet/o
		 												*	35 36 37 38 39 40 41		05
		 												*	28 29 30 31 32 33 34		04
		 												*	21 22 23 24 25 26 27		03
		 												*	14 15 16 17 18 19 20		02
		 												*	07 08 09 10 11 12 13		01
		 												*	00 01 02 03 04 05 06		00
		 												*	--------------------
		 												* x=00 01 02 03 04 05 06   
		 												*/
			
	public static byte NR_COINS_IN_X[] = new byte[7];		/* 			* 	example:
		 														* 	00 00 00 00 00 00 00
		 														* 	00 00 00 00 00 00 00
		 														* 	00 00 00 00 00 00 00
		 														*	00 00 00 01 00 00 00
		 														*	00 02 01 02 00 00 00
		 														*	01 02 02 01 01 00 00
		 														*	--------------------
		 														*	01 02 02 03 01 00 00 (corresonding value 
		 														*							in NR_COINS_IN_X)
		 														*/
	public void update_arrays_opponent_move(byte opponent) {			// update arrays after opponent's move
		SETBD[ NR_COINS_IN_X[opponent]*7 + opponent ]= (byte)1;			// we assume that opponent obeys the rules
		NR_COINS_IN_X[opponent]++; 										//  and only throws if OK (val<6!)
	}
	
	public byte play(byte opponent) {
		short eval=0x0003;
		if (opponent==NO_MOVE) { 
			set_my_first_move(); 
			return (byte) 3;  // MY first move is always in 03 column
		}										
		//------------------------------------------------------------------------------------------------------
		opponent = (byte)(opponent % 7);								// First section:  EVALUATION OPP'S MOVE
																		// check if opponent has won, and return
		if (eval_position_and_if_won(opponent, NR_COINS_IN_X[opponent], SETBD, (byte)1)==0x04) {
			return (byte) (MASK_YOUWIN | NO_MOVE);
		}
		update_arrays_opponent_move(opponent);									//
		// if (check_if_won(opponent, (byte)02))	{	return (byte) ( NO_MOVE 	| MASK_YOUWIN	);	}	//
		//------------------------------------------------------------------------------------------------------	
		//																		// Start evaluation of best move 
		BEST_MOVE		= (byte)3;
		GAME_TIED		= false;
		I_WIN 			= false;
		NO_MORE_MOVES 	= false;
		//
		//
		eval = evaluate_board(SETBD, NR_COINS_IN_X, (byte)1);
		BEST_MOVE = (byte) (eval & 0x000F);
		//
		if (((byte)eval & 0x000f)==NO_MOVE) { 
			NO_MORE_MOVES = true; 
			return (byte) ( NO_MOVE );
		}
		//
		SETBD[ NR_COINS_IN_X[BEST_MOVE]*7 + BEST_MOVE ]= (byte)2;
		NR_COINS_IN_X[BEST_MOVE]++;
		//
		if (((byte)(eval & MASK_IWIN))!=0) { 
			I_WIN = true;
			return (byte) ( BEST_MOVE 	| MASK_IWIN		);
		}
		if (((byte)(eval & MASK_TIE ))!=0) { 
			GAME_TIED = true;
			return (byte) ( BEST_MOVE 	| MASK_TIE	);
		}
		//
		return (byte) (BEST_MOVE % 7); 
	}


	public short evaluate_board(byte[] CURRBD, byte[] NR_IN_X, byte depth) {
		//		short data format:  0xABCD, where:
		//									D = LSB contains best_move recommendation
		//									CD contains D and masks MASK_IWIN, MASK_TIE, NO_MOVE
		//													return values form that branch
		//									AB contains score i.e. evaluation of best_move recomm. 
		//
		short eval=0;
		byte CURRBD_SAVE[] = new byte[42];
		byte NR_IN_X_SAVE[] = new byte[7];
		byte xme, xopp, count = (byte)0, count_opp = (byte)0, 
			curr_best1 = (byte)0, curr_best_col1 = (byte)0,
			curr_best2 = (byte)0, curr_best_col2 = (byte)0,
			i = (byte)0;
		boolean REDwins = false;  // I_WIN local
		boolean YELwins = false;  // opponent wins, local
		boolean NO_more = true;
		boolean TIE		= true;		// local TIE condition
		//-----------------------------------------------------------------CHECK EVAL for RED & YEL--
		//-----------------------------------------------------------------eval for Red = 0,2,3,4(=won)
		for (xme=0; xme<7; xme++) {							
			// for loop with possible moves of R and Y
			if (NR_IN_X[xme]<6) {		// sufficient if ONE column is not full, then NO_more = false
				NO_more = false;  		// NO_more is false if at least one column is not full
				//
				count = eval_position_and_if_won(xme, NR_IN_X[xme], CURRBD, (byte)2);
				//
				if (count==0x04) {
					REDwins = true;
					if (depth==1) { 
						return (short) ((short)0x0400 | (short)(MASK_IWIN | xme));
					} else {
						return (short) ((short)0x0400 | (short) xme);
					}
				}
				if ((curr_best2<count)&&(NR_IN_X[xme]<5)) { 	// change eval only if YEL cannot win after this move
					if (eval_position_and_if_won(xme, (byte) (NR_IN_X[xme]+1), CURRBD, (byte)1)!=0x04) {
						curr_best2=count;
						curr_best_col2 = xme;				
					} else {
						count=count;
					}
				}
			}
		}
		if (NO_more) {   // NO_more is false if at least one column is not full
			return (short) (NO_MOVE);
		}
		for (xopp=0; xopp<7; xopp++) {  //---if eval for Yellow = 4 if win possible --> red moves in there
			//
			count = eval_position_and_if_won(xopp, NR_IN_X[xopp], CURRBD, (byte)1);
			//
			if (count==0x04) {
				YELwins = true;
				if (depth==1) { 
					return (short) ((short)0x4000 | (short)(xopp));
				}
			}
			if (curr_best1<count) { 
				if (NR_IN_X[xopp]<5) {
					if (eval_position_and_if_won(xopp, (byte) (NR_IN_X[xopp]+1), CURRBD, (byte)1)!=0x04) {
						curr_best1=count;
						curr_best_col1 = xopp;
					}	
				} else {
					curr_best1=count;
					curr_best_col1 = xopp;		
				}
			}
		}
		//
//		for (i=0; i<42; i++) { CURRBD_SAVE[i]=CURRBD[i];}								// SAVE CURRENT BOARD
//		for (i=0; i<7; i++) { NR_IN_X_SAVE[i]=NR_IN_X[i];}								//
		//
//		if (depth<LOOK_AHEAD_DEPTH) {	//-----------------------------if one look-ahead deeper:  FOR-LOOP xme,xopp--
//			for (xme=0; xme<7; xme++) {	
//				for (i=0; i<42; i++) { CURRBD[i]=CURRBD_SAVE[i]; }
//				for (i=0; i<7; i++) { NR_IN_X[i]=NR_IN_X_SAVE[i]; }
//				//
//				CURRBD[ NR_IN_X[xme]*7 + xme ]= (byte)2;							//
//				NR_IN_X[xme]++;														// move color 2 into column xme
//				//
//				for (xopp=0; xopp<7; xopp++) {
//					CURRBD[ NR_IN_X[xopp]*7 + xopp ]= (byte)1;						//
//					NR_IN_X[xopp]++;												// move color 1 into column xopp
//					
//					eval = evaluate_board(CURRBD, NR_IN_X, (byte)(depth+1));
//				}
//			}
//		}
		if (curr_best1>curr_best2) {
			return (short) ((short)(0x1000*curr_best1) | (short)(curr_best_col1));
		} else {
			return (short) ((short)(0x0100*curr_best2) | (short)(curr_best_col2));
		}
	}

	public byte eval_position_and_if_won(byte column, byte y_me, byte[] BRD, byte color) {		
																	// main location evaluation function
																	// returns max count 0,1,2,3 or 4 (4 if won)
		byte XY = 	(byte) ((y_me*7)+column); // XY of current coin
		byte count_hor = (byte)0;	// count for horizontal
		byte count_ver = (byte)0;	// count for vertical 
		byte count_cw  = (byte)0;	// count for diagonal row pointing 45 degrees (upper right)
		byte count_ccw = (byte)0;	// count for diagonal row pointing -45 degrees (upper left)
		
		if (y_me>5) { 
			return (byte) 0;
		}
		if (column>0) {		// only if column=1 or larger, we can check the row LEFT to xmeloc ...
			if (BRD[XY - 1] == color) { 
				count_hor++;										// found color on the left side				-1
				if (column>1) {
					if (BRD[XY - (byte)2] == color) { 
						count_hor++; 								// and ALSO on second left side				-2
						if (column>2) {
							if (BRD[XY - (byte)3] == color) {
								count_hor++;						// and ALSO on third left side				-3
							}
						}
					}	
				} 												
			}
			if (y_me>0) {
				if (BRD[XY - 0x08]==color) { 
					count_cw++; 									// found color in left lower position		-8
					if ((y_me>1)&&(column>1)) { 
						if (BRD[XY - (byte)16] == color) { 
							count_cw++; 							// and in second lower pos.					-16
							if ((y_me>2)&&(column>2)) {
								if (BRD[XY - (byte)24] == color) {
									count_cw++;						// and in third left lower pos.				-24
								}
							}
						} 
					}
				}
			}
			if (y_me<5) {
				if (BRD[XY + 0x06]==color) { 									
					count_ccw++; 									// found MY coin in left upper position		+6
					if ((y_me<4)&&(column>1)) { 
						if (BRD[XY + (byte)12] == color) { 
							count_ccw++;							// and in 2nd left upper pos.				+12
							if ((y_me<3)&&(column>2)) {
								if (BRD[XY + (byte)18] == color) {
									count_ccw++;					// and in third left upper pos				+18
								}
							}						
						}
					}
				}
			}
		}
		if (column<6) {					// only if xmeloc=5 or lower, we can check the column RIGHT to xmeloc ...
			if (BRD[XY + 1] == color) { 
				count_hor++;										// found MY coin on the right side			+1
				if (column<5) { 
					if (BRD[XY + 2] == color) { 
						count_hor++;								// and ALSO on second right side			+2
						if (column<4) {
							if (BRD[XY + (byte)3] == color) {		// and also on third right side				+3
								count_hor++;
							}
						}	
					}
				}
			}
			if (y_me>0) {
				if (BRD[XY - 0x06]==color) { 
					count_ccw++; 										// found MY coin in right lower position	-6
					if ((y_me>1)&&(column<5)) { 
						if (BRD[XY - (byte)12] == color) { 
							count_ccw++;								// and in second lower pos.					-12
							if ((y_me>2)&&(column<4)) {
								if (BRD[XY - (byte)18]==color) {
									count_ccw++;						// and in third lower right pos.			-18
								}
							}
						}
					}
				}
			}
			if (y_me<5) { 
				if (BRD[XY + 0x08]==color) {
					count_cw++;										// found MY coin in right upper position	+8
					if ((y_me<4)&&(column<5)) { 
						if (BRD[XY + (byte)16] == color) { 
							count_cw++; 							// and in 2nd right upper pos.				+16
							if ((y_me<3)&&(column<4)) {
								if (BRD[XY + (byte)24]==color) {
									count_cw++;						// and in 3rd right upper pos.				+24
								}
							}
						}
					}
				}
			}
		}
		if (y_me>0) {
			if (BRD[XY - (byte)7] == color) { 
				count_ver++; 									// found another one of MY coins just below		-7
				if (y_me>1) { 
					if (BRD[XY - (byte)14] == color) { 
						count_ver++; 							// and another one								-14
						if (y_me>2) {
							if (BRD[XY - (byte)21]==color) {
								count_ver++;					// and another one								-21
							}
						}
					}
				}
			}
		}
		//
		if ((count_hor>0x02)||(count_ver>0x02)||(count_cw>0x02)||(count_ccw>0x02))  { return (byte)4; }
		if ((count_hor>0x01)||(count_ver>0x01)||(count_cw>0x01)||(count_ccw>0x01))  { return (byte)3; }
		if ((count_hor>0x00)||(count_ver>0x00)||(count_cw>0x00)||(count_ccw>0x00))  { return (byte)2; }
		return 0;
	}
	
	public void update_array_currbd_scores() {	count_hor++;}
	public void evaluate_me_at_xme() { count_hor++;}
	public void evaluate_opp() {count_hor++;}
	public void update_count() {count_hor++;}
	
	public void reset() {
		byte 	i;
		for (i=0; i<42; i++){	SETBD[i]=0;   }
		for (i=0; i<7; i++) {	NR_COINS_IN_X[i]=0; 	}
		GAME_TIED 		= false;
		YOU_WIN 		= false;
		I_WIN 			= false;
		NO_MORE_MOVES 	= false;
	}

	public void set_my_first_move() {
		reset();
		SETBD[0x03]=0x02;
		NR_COINS_IN_X[0x03]=0x01;
	}
	
	public void add_moves_to_arrays(byte xmeloc, byte xopploc) {
		if ((++NR_COINS_IN_X[xmeloc])<=6) 	{ SETBD[xmeloc+(7*NR_COINS_IN_X[xmeloc])]=0x02; }	
		if ((++NR_COINS_IN_X[xopploc])<=6)	{ SETBD[xopploc+(7*NR_COINS_IN_X[xopploc])]=0x01; }	
	}
	
	public void remove_moves_from_arrays(byte xmeloc, byte xopploc) {
		if ((NR_COINS_IN_X[xmeloc])<=6) 	{ SETBD[xmeloc+7*(NR_COINS_IN_X[xmeloc])]=0x00; }
		if ((NR_COINS_IN_X[xopploc])<=6) 	{ SETBD[xmeloc+7*(NR_COINS_IN_X[xmeloc])]=0x00; }
		NR_COINS_IN_X[xmeloc]--;
		NR_COINS_IN_X[xopploc]--;
	}
	
	public short identify(byte[] bArray, short bOffset) {
		short ln;
		Util.arrayCopyNonAtomic(IDENT, (short) 0, bArray, bOffset,
				(ln = (short) IDENT.length));
		return ln;
	}

	public static void install(byte[] bArray, short bOffset, byte bLength) {
		new Snippet2().register(bArray, (short) (bOffset + 1),
			bArray[bOffset]);
	}

	private Dispatcher dispatcher;

	private Snippet2() {
		(dispatcher = new Dispatcher((short) 1)).addService(
			new QuadService(this), Dispatcher.PROCESS_COMMAND);
	}

	public void process(APDU apdu) {
		dispatcher.process(apdu);
	}
}