/* ***********************************************************
 * Smart Cards: Toward a Modern Run-time Platform
 * ETH Zurich, WS 2005/2006
 * 
 * Exercise 4 - Solution
 *************************************************************/

package vault;

import javacard.framework.Util;

public class PasswordEntry {
	private final byte[] url;

	private final byte[] pass;

	PasswordEntry next;

	public PasswordEntry(byte[] url, short uOff, byte uLen, byte[] pass,
			short pOff, byte pLen) {
		this.url = new byte[uLen & 0xff];
		this.pass = new byte[pLen & 0xff];
		Util.arrayCopy(url, uOff, this.url, (short) 0, (short) (uLen & 0xff));
		Util.arrayCopy(pass, pOff, this.pass, (short) 0, (short) (pLen & 0xff));
	}

	public boolean match(byte[] url, short uOff, byte uLen) {
		if ((uLen & 0xff) != this.url.length) {
			return false;
		}
		return 0 == Util.arrayCompare(this.url, (short) 0, url, uOff,
				(short) (uLen & 0xff));
	}

	public byte[] getPass() {
		return pass;
	}
}
