/* ***********************************************************
 * Smart Cards: Toward a Modern Run-time Platform
 * ETH Zurich, WS 2005/2006
 * 
 * Exercise 4 - Solution
 *************************************************************/

package vault;

import java.rmi.Remote;
import java.rmi.RemoteException;

import javacard.framework.ISO7816;
import javacard.framework.UserException;

public interface Vault extends Remote {

	public static final short SW_NOT_AUTHORIZED = ISO7816.SW_SECURITY_STATUS_NOT_SATISFIED;

	public static final short SW_NOT_FOUND = ISO7816.SW_FILE_NOT_FOUND;

	public static final short SW_ALREADY_EXISTS = ISO7816.SW_FILE_INVALID;

	public static final short SW_INVALID_PIN = ISO7816.SW_WRONG_LENGTH;

	public static final short SW_PIN_BLOCKED = (short) 0x9840; // GSM

	public static final short SW_PIN_NOT_BLOCKED = (short) 0x9808; // GSM

	public static final short SW_WRONG_PIN = ISO7816.SW_WRONG_DATA;

	public static final short SW_MEMORY_FULL = ISO7816.SW_FILE_FULL;

	public void verifyPIN(byte[] pin) throws UserException, RemoteException;

	public void updatePIN(byte[] pin) throws UserException, RemoteException;

	public void unblockPIN(byte[] puk) throws UserException, RemoteException;

	public byte[] getPassword(byte[] URL) throws UserException, RemoteException;

	public void savePassword(byte[] URL, byte[] pass) throws UserException,
			RemoteException;

	public void removePassword(byte[] URL) throws UserException,
			RemoteException;

}
